
document.getElementById("contactForm")?.addEventListener("submit", function(e) {
  e.preventDefault();
  
  // para obtener valores de los campos
  const nombre = document.getElementById("nombre").value.trim();
  const email = document.getElementById("email").value.trim();
  const comentarios = document.getElementById("comentarios").value.trim();
  const tipoConsulta = document.getElementById("tipoConsulta").value;
  
  // empleo de if-else para validacion de campos sin rellenar
  if (!nombre || !email || !comentarios) {
    mostrarError("Todos los campos son obligatorios.");
    return;
  }
  
  // Validación del email
  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  if (!emailRegex.test(email)) {
    mostrarError("Por favor ingrese un email válido.");
    return;
  }
  
  // empleo de switch para validacion de carateres
  switch(true) {
    case nombre.length < 3:
      mostrarError("El nombre debe tener al menos 3 caracteres.");
      return;
    case comentarios.length < 10:
      mostrarError("Los comentarios deben tener al menos 10 caracteres.");
      return;
  }
  
  //empleo del condicional switch para el formulario
  let prioridad = "";
  switch(tipoConsulta) {
    case "tecnica":
      prioridad = "Alta";
      break;
    case "general":
      prioridad = "Media";
      break;
    case "sugerencia":
      prioridad = "Baja";
      break;
    default:
      prioridad = "No especificada";
  }
  
  const mensaje = document.getElementById("mensajeEnviado");
  mensaje.innerHTML = `
    <strong>¡Mensaje enviado exitosamente!</strong><br>
    Tipo: ${tipoConsulta.toUpperCase()} (Prioridad: ${prioridad})<br>
    Te responderemos a: ${email}
  `;
  mensaje.style.display = "block";
  
  setTimeout(() => {
    mensaje.style.display = "none";
  }, 5000);

  console.log("--- Nuevo mensaje recibido ---");
  const campos = {nombre, email, tipoConsulta, comentarios};
  
  // empleo del Bucle for 
  for (const campo in campos) {
    console.log(`${campo}: ${campos[campo]}`);
  }
  
  // emple del blucle while
  let contador = 3;
  console.log("Procesando mensaje...");
  while (contador > 0) {
    console.log(`Tiempo estimado: ${contador} segundos`);
    contador--;
  }
  
  document.getElementById("contactForm").reset();
});

function mostrarError(mensaje) {
  const errorDiv = document.getElementById("mensajeError");
  errorDiv.textContent = mensaje;
  errorDiv.style.display = "block";
  
  setTimeout(() => {
    errorDiv.style.display = "none";
  }, 4000);
}

function scrollToTop() {
  window.scrollTo({ top: 0, behavior: 'smooth' });
}

function toggleModo() {
  document.body.classList.toggle("modo-oscuro");
  
  
  const botonModo = document.querySelector(".boton-modo");
  if (document.body.classList.contains("modo-oscuro")) {
    botonModo.textContent = "🌞 Modo claro";
  
    localStorage.setItem('modoOscuro', 'activado');
  } else {
    botonModo.textContent = "🌓 Modo oscuro";
    localStorage.setItem('modoOscuro', 'desactivado');
  }
}


document.addEventListener('DOMContentLoaded', function() {
  if (localStorage.getItem('modoOscuro') === 'activado') {
    document.body.classList.add("modo-oscuro");
    document.querySelector(".boton-modo").textContent = "🌞 Modo claro";
  }
  
  // la animacion d la carga del inicio
  const elementosCarga = document.querySelectorAll('.carga-progresiva');
  let delay = 0;
  
  // empleo del bucle for
  for (let i = 0; i < elementosCarga.length; i++) {
    setTimeout(() => {
      elementosCarga[i].style.opacity = 1;
      elementosCarga[i].style.transform = 'translateY(0)';
    }, delay);
    delay += 100;
  }
});

//par subir la pagina  (scroll)
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
  anchor.addEventListener('click', function(e) {
    e.preventDefault();
    
    const targetId = this.getAttribute('href');
    const targetElement = document.querySelector(targetId);
    
    if (targetElement) {
      window.scrollTo({
        top: targetElement.offsetTop - 100,
        behavior: 'smooth'
      });
    }
  });
});

// la parte para subir toda la pagina  (scroll)
const observer = new IntersectionObserver((entries) => {
  entries.forEach(entry => {
    if (entry.isIntersecting) {
      entry.target.classList.add('visible');
      
      // El efecto para tablas
      if (entry.target.classList.contains('tabla-hardware')) {
        const filas = entry.target.querySelectorAll('tr');
        filas.forEach((fila, index) => {
          setTimeout(() => {
            fila.style.opacity = 1;
            fila.style.transform = 'translateX(0)';
          }, index * 100);
        });
      }
    }
  });
}, { threshold: 0.1 });

document.querySelectorAll('.articulo, .sidebar section, .tabla-hardware').forEach(section => {
  observer.observe(section);
});